/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.activate;

import com.ibm.hwmca.base.activate.ActivateErrorIDs;
import com.ibm.hwmca.base.activate.Activation;
import com.ibm.hwmca.base.activate.ActivationCT;
import com.ibm.hwmca.base.activate.ActivationCTData;
import com.ibm.hwmca.base.activate.ActivationData;
import com.ibm.hwmca.base.activate.ActivationDataForApp;
import com.ibm.hwmca.base.activate.ActivationTaskletData;
import com.ibm.hwmca.base.activate.ActivationTaskletTargetData;
import com.ibm.hwmca.base.activate.ConfirmActivateBean;
import com.ibm.hwmca.base.activate.ViewProfileBean;
import com.ibm.hwmca.base.actprof.ActivationProfileUtil;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.ReportListener;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Vector;

public class ActivationTasklet
extends HwmcaPanelTasklet
implements ActivateErrorIDs,
ProgressEndedListener,
ProgressCancelListener {
    private static final String TRACE_MASKT = "XACTAPTT";
    private static final String TRACE_MASKF = "XACTAPTF";
    private static final String TRACE_MASKD = "XACTAPTD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.activate.res.ConfirmActivateRes";
    private static final String PANEL_NAME_NORMAL = "ConfirmActivatePanel";
    private static final String PANEL_NAME_HIGHLIGHT = "ConfirmActivatePanelRed";
    private static final String PANEL_BEAN_NAME = "ConfirmActivatePanel";
    private static final String VP_PANEL_NAME = "ViewProfilePanel";
    private boolean progressDismissed = false;
    ReportListener listener;
    boolean highlightConfirmationPanel = false;
    ConfirmActivateBean caBean;
    Vector ourThreads = new Vector();
    private static final String id = "1";
    boolean isActivate = false;

    public ActivationTasklet() {
        Trace.trace(TRACE_MASKT, "<>ActivationTasklet() constructor");
        this.setExplicitTerminate(true);
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException()");
        Trace.trace(TRACE_MASKT, "Exception is " + throwable);
        new FrameworkLog(ActivateErrorIDs.LOGINFO, 18192, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) {
        Trace.trace(TRACE_MASKF, "-> service()");
        try {
            Trace.trace(TRACE_MASKF, "See what request came in = " + taskletRequest);
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            ActivationCT ourTask = (ActivationCT)mom.get(this.presentationTaskParms.getTaskId());
            if (ourTask.getName().equals("base.task.activate")) {
                this.isActivate = true;
            }
            if (taskletRequest.isInitialRequest()) {
                Trace.trace(TRACE_MASKF, "Initial request = " + ourTask.getName());
                ActivationCTData ctData = new ActivationCTData();
                ArrayList activationGroupTargetLists = ctData.getTargetData(this.presentationTaskParms);
                if (activationGroupTargetLists != null) {
                    if (this.isActivate) {
                        Trace.trace(TRACE_MASKF, "  -- Activate request");
                        int numObjects = 0;
                        ObjectId[] oids = this.presentationTaskParms.getTargetIds();
                        for (int j = 0; j < activationGroupTargetLists.size(); ++j) {
                            ActivationDataForApp[] ads = ActivationCTData.getTargetListForN(activationGroupTargetLists, j);
                            if (ads == null) continue;
                            for (int ads_index = 0; ads_index < ads.length; ++ads_index) {
                                boolean foundMatch = false;
                                for (int oids_index = 0; oids_index < oids.length && !foundMatch; ++oids_index) {
                                    if (!oids[oids_index].equals(ads[ads_index].getManagedObject().getObjectId())) continue;
                                    ++numObjects;
                                    foundMatch = true;
                                }
                                if (foundMatch) continue;
                                if (ads.length == 1) {
                                    Trace.trace(TRACE_MASKD, "only one item in list, remove list");
                                    activationGroupTargetLists.remove(j);
                                    continue;
                                }
                                Trace.trace(TRACE_MASKD, "Activate Request Point 0500");
                                ActivationDataForApp[] newADArray = new ActivationDataForApp[ads.length - 1];
                                ArrayList<ActivationDataForApp> groupList = new ArrayList<ActivationDataForApp>(ads.length - 1);
                                int m = 0;
                                for (int l = 0; l < ads.length; ++l) {
                                    if (l == ads_index) continue;
                                    newADArray[m] = ads[l];
                                    groupList.add(ads[l]);
                                    ++m;
                                }
                                activationGroupTargetLists.set(j, groupList);
                                ads = newADArray;
                                --ads_index;
                            }
                        }
                        ActivationTaskletTargetData[] attd = new ActivationTaskletTargetData[numObjects];
                        int objectIndex = 0;
                        for (int j = 0; j < activationGroupTargetLists.size(); ++j) {
                            ActivationDataForApp[] ads = ActivationCTData.getTargetListForN(activationGroupTargetLists, j);
                            for (int ads_index = 0; ads_index < ads.length; ++ads_index) {
                                for (int oids_index = 0; oids_index < oids.length; ++oids_index) {
                                    if (!oids[oids_index].equals(ads[ads_index].getManagedObject().getObjectId())) continue;
                                    ManagedObject mo = ads[ads_index].getManagedObject();
                                    UIInfo uiinfo = mo.getUIInfo();
                                    String name = uiinfo.getName();
                                    Trace.trace(TRACE_MASKD, "  uiinfo.getName() = " + name);
                                    name = name.replace('\n', ':').trim();
                                    if (name.startsWith(":")) {
                                        name = name.substring(1);
                                    }
                                    Trace.trace(TRACE_MASKD, "  changed name.replace() = " + name);
                                    attd[objectIndex] = new ActivationTaskletTargetData(mo.getObjectId(), name, ads[ads_index].getLastUsedProfileName(), ads[ads_index].getNextProfileName(), ads[ads_index].getHighlightConfirmation());
                                    if (ads[ads_index].getHighlightConfirmation()) {
                                        this.highlightConfirmationPanel = true;
                                    }
                                    ++objectIndex;
                                }
                            }
                        }
                        ActivationTaskletData atd = new ActivationTaskletData(attd, 0);
                        this.caBean = new ConfirmActivateBean(atd);
                        this.caBean.setBeanName("ConfirmActivatePanel");
                        if (this.highlightConfirmationPanel) {
                            Trace.trace(TRACE_MASKF, "Highlight confirmation panel");
                            taskletResponse.replace(AUIML_FILE_NAME, PANEL_NAME_HIGHLIGHT, this.caBean);
                        } else {
                            Trace.trace(TRACE_MASKF, "Normal confirmation panel");
                            taskletResponse.replace(AUIML_FILE_NAME, "ConfirmActivatePanel", this.caBean);
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "  -- Deactivate request");
                        this.ActDeact(activationGroupTargetLists, taskletResponse, ourTask);
                    }
                }
            } else {
                String classname = (String)taskletRequest.getData("beanname");
                Trace.trace(TRACE_MASKF, "classname from request is " + classname);
                if (classname != null && classname.endsWith("ConfirmActivateBean") || classname == null) {
                    if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                        Trace.trace(TRACE_MASKF, "panel was cancelled or disposed");
                        taskletResponse.terminate();
                    } else {
                        Trace.trace(TRACE_MASKF, "Do regular service() processing");
                        ActivationTaskletData atd = (ActivationTaskletData)taskletRequest.getData("Key A");
                        if (atd == null) {
                            Trace.trace(TRACE_MASKF, "ATD=NULL, Assume panel was cancelled or disposed");
                            taskletResponse.terminate();
                        } else {
                            ActivationTaskletTargetData[] attd = atd.getActivationTaskletTargetData();
                            if (atd == null) {
                                Trace.trace(TRACE_MASKF, "Assume panel was cancelled or disposed");
                                taskletResponse.terminate();
                            } else {
                                int command = atd.getCommand();
                                Trace.trace(TRACE_MASKF, "Command = " + command);
                                switch (command) {
                                    default: {
                                        Trace.trace(TRACE_MASKF, "Command = NOP");
                                        break;
                                    }
                                    case 1: {
                                        Trace.trace(TRACE_MASKF, "Command = YES");
                                        PanelTaskletRequest request = new PanelTaskletRequest();
                                        atd.setCommand(4);
                                        request.setData("Key A", atd);
                                        request.setData("beanname", "ConfirmActivateBean");
                                        this.postRequest(null, request);
                                        taskletResponse.dispose();
                                        break;
                                    }
                                    case 4: {
                                        Trace.trace(TRACE_MASKF, "Command = ACTIVATE");
                                        ActivationCTData ctData = new ActivationCTData();
                                        ArrayList activationGroupTargetLists = ctData.getTargetData(this.presentationTaskParms);
                                        this.ActDeact(activationGroupTargetLists, taskletResponse, ourTask);
                                        break;
                                    }
                                    case 2: {
                                        Trace.trace(TRACE_MASKF, "Command = NO");
                                        taskletResponse.dispose();
                                        break;
                                    }
                                    case 3: {
                                        Trace.trace(TRACE_MASKF, "Command = DETAILS");
                                        ViewProfileBean vpBean = new ViewProfileBean(atd);
                                        taskletResponse.replace(AUIML_FILE_NAME, VP_PANEL_NAME, vpBean);
                                    }
                                }
                            }
                        }
                    }
                } else if (classname != null && classname.endsWith("ViewProfileBean")) {
                    if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                        Trace.trace(TRACE_MASKF, "panel was cancelled or disposed");
                        if (this.highlightConfirmationPanel) {
                            Trace.trace(TRACE_MASKF, "Highlight confirmation panel");
                            taskletResponse.replace(AUIML_FILE_NAME, PANEL_NAME_HIGHLIGHT, this.caBean);
                        } else {
                            Trace.trace(TRACE_MASKF, "Normal confirmation panel");
                            taskletResponse.replace(AUIML_FILE_NAME, "ConfirmActivatePanel", this.caBean);
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "Do regular service() processing");
                        ActivationTaskletData atd = (ActivationTaskletData)taskletRequest.getData("Key A");
                        if (atd == null) {
                            Trace.trace(TRACE_MASKF, "ATD=NULL, Assume panel was cancelled or disposed");
                            if (this.highlightConfirmationPanel) {
                                Trace.trace(TRACE_MASKF, "Highlight confirmation panel");
                                taskletResponse.replace(AUIML_FILE_NAME, PANEL_NAME_HIGHLIGHT, this.caBean);
                            } else {
                                Trace.trace(TRACE_MASKF, "Normal confirmation panel");
                                taskletResponse.replace(AUIML_FILE_NAME, "ConfirmActivatePanel", this.caBean);
                            }
                        } else {
                            ActivationTaskletTargetData[] attd = atd.getActivationTaskletTargetData();
                            if (atd == null) {
                                Trace.trace(TRACE_MASKF, "Assume panel was cancelled or disposed");
                                if (this.highlightConfirmationPanel) {
                                    Trace.trace(TRACE_MASKF, "Highlight confirmation panel");
                                    taskletResponse.replace(AUIML_FILE_NAME, PANEL_NAME_HIGHLIGHT, this.caBean);
                                } else {
                                    Trace.trace(TRACE_MASKF, "Normal confirmation panel");
                                    taskletResponse.replace(AUIML_FILE_NAME, "ConfirmActivatePanel", this.caBean);
                                }
                            } else {
                                int command = atd.getCommand();
                                Trace.trace(TRACE_MASKF, "Command = " + command);
                                switch (command) {
                                    default: {
                                        Trace.trace(TRACE_MASKF, "Command = NOP");
                                        break;
                                    }
                                    case 3: {
                                        Trace.trace(TRACE_MASKF, "Command = DETAILS");
                                        ActivationTaskletTargetData oneattd = atd.getShowDetailsFor();
                                        ManagedObject mo = (ManagedObject)mom.get(oneattd.getTarget());
                                        String profileName = oneattd.getNextProfileName().trim();
                                        if (profileName.length() == 0) {
                                            profileName = "DEFAULT";
                                        }
                                        ActivationProfileUtil apu = new ActivationProfileUtil();
                                        Trace.trace(TRACE_MASKF, "selected object's name is " + oneattd.getName());
                                        Trace.trace(TRACE_MASKF, "selected object's ID " + oneattd.getTarget());
                                        Trace.trace(TRACE_MASKF, "selected object's mo = " + mo);
                                        Trace.trace(TRACE_MASKF, "selected object's profile name = " + profileName);
                                        apu.editProfile(mo, profileName, this, taskletResponse, true);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during service is " + e);
            new FrameworkLog(ActivateErrorIDs.LOGINFO, 18196, e).log();
        }
        if (!taskletResponse.isResponseSet()) {
            taskletResponse.noAction();
        }
        Trace.trace(TRACE_MASKF, "<- service()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ActDeact(ArrayList activationGroupTargetLists, PanelTaskletResponse taskletResponse, ActivationCT ourTask) {
        Trace.trace(TRACE_MASKF, "-> ActDeact()");
        try {
            if (this.isActivate) {
                ourTask.updateTasksPerformedAlways(this.presentationTaskParms);
            }
            LocalizableText taskNameLT = ourTask.getUIInfo().getUnlocalizedName();
            long duration = 5400L;
            if (!this.isActivate) {
                duration = 900L;
            }
            LocalizableText initialText = null;
            initialText = !this.isActivate ? new LocalizableText("com/ibm/hwmca/base/res/text", "deactivate.progress.text") : new LocalizableText("com/ibm/hwmca/base/res/text", "activate.progress.text");
            int numTargets = 0;
            for (int i = 0; i < activationGroupTargetLists.size(); ++i) {
                ActivationDataForApp[] ads = ActivationCTData.getTargetListForN(activationGroupTargetLists, i);
                numTargets += ads.length;
            }
            Trace.trace(TRACE_MASKF, "Number of Valid targets = " + numTargets);
            ProgressData[] progData = new ProgressData[numTargets];
            ManagedObject[] allMOs = new ManagedObject[numTargets];
            int pdIndex = 0;
            for (int i = 0; i < activationGroupTargetLists.size(); ++i) {
                ActivationDataForApp[] ads = ActivationCTData.getTargetListForN(activationGroupTargetLists, i);
                for (int j = 0; j < ads.length; ++j) {
                    allMOs[pdIndex] = ads[j].getManagedObject();
                    progData[pdIndex] = new ProgressData(allMOs[pdIndex].getUIInfo().getUnlocalizedName(), ads[j].getManagedObject().getObjectId(), duration);
                    ++pdIndex;
                    Trace.trace(TRACE_MASKF, "Name of target is " + ads[j].getManagedObject().getName());
                }
            }
            Trace.trace(TRACE_MASKF, "Just before the ProgressStartEvent");
            Trace.trace(TRACE_MASKF, "task name = " + taskNameLT);
            Trace.trace(TRACE_MASKF, "ProgressData = " + progData);
            Trace.trace(TRACE_MASKF, "duration = " + duration);
            Trace.trace(TRACE_MASKF, "initial Text = " + initialText);
            Trace.trace(TRACE_MASKF, "id = 1");
            ObjectId[] allMOIs = this.presentationTaskParms.getTargetIds();
            ProgressStartEvent start = new ProgressStartEvent(taskNameLT, progData, duration, initialText, id, (ProgressCancelListener)this, (ProgressEndedListener)this);
            this.startProgress(start);
            try {
                PanelTaskletProgressListener progListener = new PanelTaskletProgressListener(this);
                this.listener = new ProgressReportListenerImpl(id, allMOIs, progListener);
                Trace.trace(TRACE_MASKF, "Just before the synchronized call and wait");
                ActivationTasklet activationTasklet = this;
                synchronized (activationTasklet) {
                    try {
                        Trace.trace(TRACE_MASKF, "About to wait for completion");
                        for (int i = 0; i < activationGroupTargetLists.size(); ++i) {
                            ActivationData[] ads = ActivationCTData.getTargetListForN(activationGroupTargetLists, i);
                            if (ads.length <= 0) continue;
                            Activation act = ads[0].getActivationImplClass();
                            MyThread mt = new MyThread(act, ads, this.listener);
                            if (this.isActivate) {
                                this.ourThreads.add(mt);
                            }
                            String name = "ActivationClassThread=" + act.getClass().getName();
                            new Thread((Runnable)mt, name).start();
                        }
                        while (!this.progressDismissed) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException iexc) {}
                        }
                        taskletResponse.terminate();
                    }
                    catch (Exception e) {
                        new FrameworkLog(ActivateErrorIDs.LOGINFO, 18195, e).log();
                        if (allMOs != null) {
                            for (int i = 0; i < allMOs.length; ++i) {
                                CompletionReport report = new CompletionReport(allMOs[i].getObjectId(), CompletionReportCode.FAIL);
                                this.listener.completeReport(report);
                            }
                        }
                        this.endProgress(new ProgressEndEvent(id));
                    }
                }
            }
            catch (Exception exc) {
                new FrameworkLog(ActivateErrorIDs.LOGINFO, 18194, exc).log();
                if (allMOs != null) {
                    for (int i = 0; i < allMOs.length; ++i) {
                        CompletionReport report = new CompletionReport(allMOs[i].getObjectId(), CompletionReportCode.FAIL);
                        this.listener.completeReport(report);
                    }
                }
                this.endProgress(new ProgressEndEvent(id));
                Trace.trace(TRACE_MASKF, "ActivationTasklet is ending due to error completion");
                taskletResponse.terminate();
            }
        }
        catch (Exception exc) {
            new FrameworkLog(ActivateErrorIDs.LOGINFO, 18193, exc).log();
            try {
                this.endProgress(new ProgressEndEvent(id));
                Trace.trace(TRACE_MASKF, "ActivationTasklet is ending due to error completion");
            }
            catch (Exception doubleException) {
                Trace.trace(TRACE_MASKF, "We are already handling an exception; ignore the second one: " + doubleException);
            }
            taskletResponse.terminate();
        }
        Trace.trace(TRACE_MASKF, "<- ActDeact()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> progressEnded()");
        ActivationTasklet activationTasklet = this;
        synchronized (activationTasklet) {
            this.progressDismissed = true;
            this.notify();
        }
        Trace.trace(TRACE_MASKT, "<- progressEnded()");
    }

    public void progressCanceled(String id) {
        Trace.trace(TRACE_MASKT, "<- ActivationTasklet.progressCancelled()");
        if (this.ourThreads != null) {
            this.ourThreads.trimToSize();
            int numThreads = this.ourThreads.size();
            for (int i = 0; i < numThreads; ++i) {
                MyThread mt = (MyThread)this.ourThreads.elementAt(i);
                mt.cancelActivate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- ActivationTasklet.progressCancelled()");
    }

    class MyThread
    implements Runnable,
    ActivateErrorIDs {
        private Activation _act;
        private ActivationData[] _ads;
        private ReportListener _listener;

        public MyThread(Activation act, ActivationData[] ads, ReportListener listener) {
            Trace.trace(ActivationTasklet.TRACE_MASKT, "-> MyThread constructor");
            this._act = act;
            this._ads = ads;
            this._listener = listener;
            Trace.trace(ActivationTasklet.TRACE_MASKT, "<- MyThread constructor");
        }

        public void cancelActivate() {
            Trace.trace(ActivationTasklet.TRACE_MASKT, "-> MyThread.cancelActivate()");
            Trace.trace(ActivationTasklet.TRACE_MASKT, " about to call _act.cancelActivate()");
            try {
                this._act.cancelActivate(this._ads, this._listener);
            }
            catch (Exception exc) {
                Trace.trace(ActivationTasklet.TRACE_MASKT, " exception was " + exc);
            }
            Trace.trace(ActivationTasklet.TRACE_MASKT, "<- MyThread.cancelActivate()");
        }

        public void run() {
            block5: {
                Trace.trace(ActivationTasklet.TRACE_MASKT, "-> MyThread.run()");
                try {
                    Trace.trace(ActivationTasklet.TRACE_MASKF, "_act = " + this._act);
                    Trace.trace(ActivationTasklet.TRACE_MASKF, "_ads = " + this._ads);
                    Trace.trace(ActivationTasklet.TRACE_MASKF, "_listener = " + this._listener);
                    if (ActivationTasklet.this.isActivate) {
                        Trace.trace(ActivationTasklet.TRACE_MASKT, " about to call _act.activate()");
                        this._act.activate(this._ads, this._listener);
                    } else {
                        Trace.trace(ActivationTasklet.TRACE_MASKT, " about to call _act.deactivate()");
                        this._act.deactivate(this._ads, this._listener);
                    }
                }
                catch (Exception exc) {
                    HException hexc = new HException(exc);
                    new FrameworkLog(ActivateErrorIDs.LOGINFO, 18424, hexc).log();
                    if (this._ads == null) break block5;
                    for (int i = 0; i < this._ads.length; ++i) {
                        CompletionReport report = new CompletionReport(this._ads[i].getManagedObject().getObjectId(), CompletionReportCode.FAIL);
                        ActivationTasklet.this.listener.completeReport(report);
                    }
                }
            }
            Trace.trace(ActivationTasklet.TRACE_MASKT, "<- MyThread.run()");
        }
    }
}

